<?php

namespace Database\Seeders;

use App\Models\Setting;
use Illuminate\Database\Seeder;

class SettingSeeder extends Seeder
{
    public function run(): void
    {
        $website = [
            'landing' => [
                'home' => [
                    'headingLine1' => 'Bring Your Imagination to Life with',
                    'headingLine2' => 'AI-Powered Coloring Book',
                    'subheading' => 'Generate custom coloring pages instantly with AI, then bring them to life with your own colors!',
                    'image' => '/assets/images/landing-home.png',
                    'platforms' => [
                        'web' => env('APP_URL'),
                        'android' => 'https://play.google.com',
                        'ios' => 'https://www.apple.com/in/app-store',
                        'windows' => '',
                        'mac' => '',
                        'debian' => '',
                    ],
                    'visibility' => true,
                ],
                'howItWorks' => [
                    'subheading' => 'Easy steps to start your coloring journey!',
                    'instructions' => [
                        [
                            'id' => "1",
                            'content' =>  "Check our pricing options and create an account that fits your needs. You can also sign up for a free trial to explore our features with no commitment.",
                        ],
                        [
                            'id' => "2",
                            'content' => "Describe the illustration you want to color, and our AI will create a unique coloring page based on your words.",
                        ],
                        [
                            'id' => "3",
                            'content' => "Unleash your creativity and bring your coloring page to life! Use our intuitive tools to add colors and personalize your artwork.",
                        ],
                        [
                            'id' => "4",
                            'content' => "Once you finish coloring, you can save, download, or print your masterpiece to share with friends and family.",
                        ],
                        [
                            'id' => "5",
                            'content' => "Not in the mood to create? Browse and search our collection of public coloring pages to find the perfect one to color.",
                        ],
                        [
                            'id' => "6",
                            'content' => "Found a page you love but short on time? Add it to your favorites and return to it later when you're ready to color.",
                        ],
                        [
                            'id' => "7",
                            'content' => "Our app offers additional features to enhance your coloring experience, making it a fun and engaging activity for everyone!",
                        ]
                    ],
                    'visibility' => true,
                ],
                'features' => [
                    'subheading' => 'Everything you need for a fun and creative coloring experience',
                    'image' => '/assets/images/features.png',
                    'features' => [
                        [
                            'id' => "1",
                            'icon' => "focus-2-line",
                            'title' => "Flexible plans",
                            'description' =>
                            "Choose from a flexible pricing options that fit your needs.",
                        ],
                        [
                            'id' => "2",
                            'icon' => "coupon-2-line",
                            'title' => "Free trial",
                            'description' =>
                            "Try out our platform with a free trial plan, allowing you to explore all features without any commitment.",
                        ],
                        [
                            'id' => "3",
                            'icon' => "sparkling-line",
                            'title' => "AI-Generated pages",
                            'description' =>
                            "Easily create unique coloring pages using our advanced AI technology.",
                        ],
                        [
                            'id' => "4",
                            'icon' => "book-shelf-line",
                            'title' => "Public library",
                            'description' =>
                            "Browse our extensive library of public coloring pages to find the perfect one for you.",
                        ],
                        [
                            'id' => "5",
                            'icon' => "heart-3-line",
                            'title' => "Favorites list",
                            'description' =>
                            "Save coloring pages to your favorites for easy access later.",
                        ],
                        [
                            'id' => "6",
                            'icon' => "palette-line",
                            'title' => "User-friendly tools",
                            'description' =>
                            "Enjoy the best and easiest-to-use coloring tools to enhance your creative experience.",
                        ],
                        [
                            'id' => "7",
                            'icon' => "image-ai-line",
                            'title' => "Manage your artwork",
                            'description' =>
                            "Effortlessly organise, save, download, and print your completed coloring pages.",
                        ],
                    ],
                    'visibility' => true,
                ],
                'testimonials' => [
                    'subheading' => 'What our users are saying',
                    'image' => '/assets/images/testimonial.png',
                    'testimonials' => [
                        [
                            'id' => "1",
                            'name' => 'Emily Rodriguez',
                            'location' => 'Willow Creek, Vermont',
                            'photo' => 'https://placehold.co/100x100',
                            'feedback' => 'I tried ColorPlay with my kids, and they absolutely loved it! We can create unique pages together and color them on the spot or print them out. It’s now our favorite family activity, and I love that it sparks their creativity without any screen overload.',
                        ],
                        [
                            'id' => "2",
                            'name' => 'Sarah Johnson',
                            'location' => 'Austin, Texas',
                            'photo' => 'https://placehold.co/100x100',
                            'feedback' => 'I absolutely love this app! The AI-generated coloring pages are stunning and so unique. My kids are thrilled to see their favorite animals and themes turned into beautiful line art they can color. It\'s so easy to use, and the ability to print and color offline is a huge plus for family time. Highly recommend it for both kids and adults!',
                        ],
                        [
                            'id' => "3",
                            'name' => 'Carlos Rivera',
                            'location' => 'Barcelona, Spain',
                            'photo' => 'https://placehold.co/100x100',
                            'feedback' => 'I didn’t think I’d enjoy coloring so much as an adult, but this app changed my perspective. The AI-generated patterns are mesmerizing, and they’ve helped me relax after long workdays. My niece also loves it, so we often color together—whether digitally or with printed pages. Fantastic tool!',
                        ]
                    ],
                    'visibility' => true,
                ],
                'metrics' => [
                    'metrics' => [
                        [
                            'id' => "1",
                            'key' => 'Users',
                            'value' => '45K+',
                        ],
                        [
                            'id' => "2",
                            'key' => 'Rating',
                            'value' => '4.9',
                        ],
                        [
                            'id' => "3",
                            'key' => 'Public pages',
                            'value' => '39K+',
                        ],
                        [
                            'id' => "4",
                            'key' => 'Pages colored',
                            'value' => '210K+',
                        ],
                    ],
                    'visibility' => true,
                ],
                'pricing' => [
                    'subheading' => 'Flexible plans to fit your creative needs',
                    'visibility' => true,
                ],
                'faqs' => [
                    'subheading' => 'Find answers to our most common questions',
                    'image' => '/assets/images/faqs.png',
                    'support' => [
                        'heading' => "Can't find an answer?",
                        'description' => 'Whether you have questions or need assistance, we’re here to help!',
                        'link' => 'mailto:example@yourdomain.com',
                    ],
                    'faqs' => [
                        [
                            'id' => "1",
                            'question' => 'What does the free trial include?',
                            'answer' => 'The free trial includes the creation of 3 public coloring pages and the ability to create 2 new pages using AI.'
                        ],
                        [
                            'id' => "2",
                            'question' => 'What happens after I use all my free trial credits?',
                            'answer' => 'Once you have used all your free trial credits, you can upgrade to one of our premium monthly subscription plans to continue accessing the features.'
                        ],
                        [
                            'id' => "3",
                            'question' => 'How does the AI generate coloring pages?',
                            'answer' => 'The AI analyzes your input (such as themes, styles, or keywords) to create personalized, high-quality black-and-white line art for coloring.'
                        ],
                        [
                            'id' => "4",
                            'question' => 'Does the app allow me to color digitally?',
                            'answer' => 'Absolutely! You can color directly in the app using a variety of brushes and colors.'
                        ],
                        [
                            'id' => "5",
                            'question' => 'Can I download and print the coloring pages?',
                            'answer' => 'Yes, you can download the pages in high resolution and print them for offline use.'
                        ],
                    ],
                    'visibility' => true,
                ],
                'callToAction' => [
                    'heading' => 'Join the fun and start coloring!',
                    'description' => 'Explore a world of endless creativity where you can generate unique coloring pages and bring them to life with your own colors.',
                    'visibility' => true,
                ],
                'contact' => [
                    'subheading' => 'Have questions or feedback? We’d love to hear from you!',
                    'image' => '/assets/images/contact.png',
                    'location' => '123 Main Street, Springfield, IL, USA',
                    'phone' => '+1 555-555-5555',
                    'email' => 'contact@example.com',
                    'visibility' => true,
                ],
                'footer' => [
                    'socials' => [
                        [
                            'id' => "1",
                            'icon' => "facebook-line",
                            'url' => "https://facebook.com",
                        ],
                        [
                            'id' => "2",
                            'icon' => "instagram-line",
                            'url' => "https://instagram.com",
                        ],
                        [
                            'id' => "3",
                            'icon' => "twitter-x-line",
                            'url' => "https://twitter.com",
                        ],
                        [
                            'id' => "4",
                            'icon' => "youtube-line",
                            'url' => "https://youtube.com",
                        ],
                        [
                            'id' => "5",
                            'icon' => "tiktok-line",
                            'url' => "https://www.tiktok.com",
                        ],
                    ],
                    'visibility' => true,
                ]
            ],
            'privacy' => [
                'article' => '<p><strong>Effective Date:</strong> [Insert Date]</p>
                    <p>At <strong>[Your Website Name]</strong>, we are committed to protecting your privacy. This Privacy Policy outlines how we collect, use, and safeguard your information.</p>
                    <h3>Information We Collect</h3>
                    <p>We may collect personal information such as your name, email address, and other relevant details when you interact with our website. We use this information to provide you with the best experience.</p>
                    <h3>How We Use Your Information</h3>
                    <p>We use your personal information to improve our services, communicate with you, and enhance your user experience. We do not share your personal information with third parties without your consent.</p>
                    <h3>Cookies</h3>
                    <p>Our website may use cookies to improve user experience. Cookies are small files that are stored on your device to track your activity on our site. You can choose to disable cookies through your browser settings.</p>
                    <h3>Data Security</h3>
                    <p>We take reasonable precautions to protect your information from unauthorized access, alteration, or destruction.</p>
                    <h3>Your Rights</h3>
                    <p>You may request access to, correction of, or deletion of your personal data at any time. If you have any questions about your data or privacy concerns, please contact us.</p>
                    <h3>Changes to This Privacy Policy</h3>
                    <p>We may update this policy from time to time. When we do, we will post the updated policy on this page.</p>
                    <h3>Contact Us</h3>
                    <p>If you have any questions or concerns, please contact us at <strong>[Your Contact Information]</strong>.</p>',
                'visibility' => true,
            ],
            'terms' => [
                'article' => '<p><strong>Effective Date:</strong> [Insert Date]</p>
                    <p>Welcome to <strong>[Your Website Name]</strong>. By accessing or using our website, you agree to comply with and be bound by these Terms and Conditions.</p>
                    <h3>Use of Website</h3>
                    <p>You agree to use this website only for lawful purposes and in a way that does not infringe the rights of others or restrict their use and enjoyment of the site.</p>
                    <h3>Content</h3>
                    <p>All content on this website, including text, images, and graphics, is the property of <strong>[Your Website Name]</strong> unless otherwise stated. You may not copy, reproduce, or distribute any content without permission.</p>
                    <h3>Privacy</h3>
                    <p>Your use of our website is also governed by our <a href="/privacy">Privacy Policy</a>, which outlines how we collect and use your personal information.</p>
                    <h3>Limitation of Liability</h3>
                    <p><strong>[Your Website Name]</strong> will not be liable for any damages arising from the use or inability to use the website, including indirect or consequential damages.</p>
                    <h3>Changes to Terms</h3>
                    <p>We reserve the right to modify or update these Terms and Conditions at any time. Any changes will be posted on this page with an updated effective date.</p>
                    <h3>Contact Us</h3>
                    <p>If you have any questions about these Terms and Conditions, please contact us at <strong>[Your Contact Information]</strong>.</p>',
                'visibility' => true,
            ]
        ];
        $settings = [
            ['name' => 'app_name', 'value' => 'ColorPlay'],
            ['name' => 'tagline', 'value' => 'The fun way to color your world!'],
            ['name' => 'favicon', 'value' => '/assets/favicon.svg'],
            ['name' => 'openai_key', 'value' => null],
            ['name' => 'stripe_key', 'value' => null],
            ['name' => 'stripe_webhook_secret', 'value' => null],
            ['name' => 'website', 'value' => json_encode($website)],
        ];
        Setting::insert($settings);
    }
}
