<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\App;

class DatabaseSeeder extends Seeder
{
    public function run(): void
    {
        if (App::environment('production')) {
            $this->call([
                PlanSeeder::class,
                SettingSeeder::class,
            ]);
        } else {
            $this->call([
                PlanSeeder::class,
                UserSeeder::class,
                CreditSeeder::class,
                PageSeeder::class,
                FavoritedSeeder::class,
                ColoredSeeder::class,
                SubscriptionSeeder::class,
                SettingSeeder::class,
            ]);
        }
    }
}
