<?php

namespace Database\Seeders;

use App\Models\Page;
use App\Models\User;
use Illuminate\Database\Seeder;

class ColoredSeeder extends Seeder
{
    public function run(): void
    {
        $users = User::excludeAdmin()->get();
        $users->each(function ($user) {
            $count = rand(2, 10);
            $pages = Page::randomOf($count)->get();
            $coloreds = $pages->mapWithKeys(function ($page) {
                return [$page->id => [
                    'photo' => $page->illustration,
                    'preview' => $page->illustration,
                ]];
            });
            $user->coloredPages()->attach($coloreds);
        });
    }
}
