<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class SubscriptionFactory extends Factory
{
    public function definition(): array
    {
        return [
            'stripe_id' => 'sub_' . Str::random(14),
            'price' => $this->faker->randomFloat(2, 5, 100),
            'expire_at' => $this->faker->dateTimeBetween('now', '+1 year'),
            'canceled_at' => $this->faker->optional()->dateTimeBetween('-1 year', 'now'),
            'created_at' => fake()->dateTimeBetween('-6 months', 'now'),
            'updated_at' => fake()->dateTimeBetween('-6 months', 'now'),
        ];
    }
}
