<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

class PageFactory extends Factory
{
    public function definition(): array
    {
        return [
            'prompt' => fake()->paragraph(3),
            'illustration' => fake()->imageUrl(1024, 1024, 'illustration'),
            'colored_count' => fake()->numberBetween(0, 1000),
            'favorited_count' => fake()->numberBetween(0, 500),
            'trending' => fake()->boolean(20),
            'blocked' => fake()->boolean(5),
            'created_at' => fake()->dateTimeBetween('-6 months', 'now'),
            'updated_at' => fake()->dateTimeBetween('-6 months', 'now'),
        ];
    }
}
