<?php

namespace App\Services;

use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

class StorageService
{
    public static function upload(UploadedFile $file)
    {
        $extension = $file->getClientOriginalExtension();
        $filename = Str::uuid() . '.' . $extension;
        $path = $file->storeAs('files', $filename, 'public');
        return route('storage', ['path' => $path]);
    }

    public static function save(string $content, string $extension)
    {
        $path = 'files/' . Str::uuid() . '.' . $extension;
        Storage::disk('public')->put($path, $content);
        return route('storage', ['path' => $path]);
    }
}
