<?php

namespace App\Models;

use App\Scopes\DailyCountBetweenDate;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Subscription extends Model
{
    use HasFactory, DailyCountBetweenDate;

    protected $fillable = [
        'user_id',
        'plan_id',
        'stripe_id',
        'price',
        'expire_at',
        'canceled_at',
    ];

    protected function casts(): array
    {
        return [
            'price' => 'double',
            'expire_at' => 'datetime',
            'canceled_at' => 'datetime',
        ];
    }

    public function user() {
        return $this->belongsTo(User::class);
    }

    public function plan() {
        return $this->belongsTo(Plan::class);
    }
}
