<?php

namespace App\Http\Controllers;

use App\Repos\SubscriptionRepo;
use App\Services\ResponseService;
use App\Services\ValidationService;
use Illuminate\Http\Request;
use Throwable;

class SubscriptionController extends Controller
{
    public function paginate(Request $request) {
        try {
            $rules = [
                'page' => ['required', 'integer', 'min:1'],
                'search' => ['nullable', 'string'],
            ];
            ValidationService::validate($request->query(), $rules);
            $result = SubscriptionRepo::paginate($request->page, $request->search);
            return ResponseService::ok($result);
        } catch (Throwable $error) {
            return ResponseService::handleError($error);
        }
    }
}
